#ifndef _ANIMATION_H__
#define _ANIMATION_H__

#include "SDL.h"
#include <vector>
using std::vector;

class ASFrame
{
    public:
    SDL_Surface* pic;
    int delay;  // in milliseconds
    
    ASFrame()
        : pic(NULL)
        , delay(50)
    {}
    ASFrame(SDL_Surface* pic)
        : pic(pic)
        , delay(50)
    {}
    ASFrame(SDL_Surface* pic, int delay)
        : pic(pic)
        , delay(delay)
    {}
    ~ASFrame()
    {}
};

class ASAnimation
{
private:
    int w, h;
    float speed;  // should be frames per millisecond or maybe ms / f so we don't have to divide

    int currentFrame;
    int lastUpdate;
    SDL_Rect blitRect;
    bool pause;
    int pauseTime;
    int numLoops;  // number of times to play animation

    bool drawn; // Makes it possible to automatically forget about clearBack() when draw() isn't called
    // So you should use clearBack(), getBack(), and draw() every frame.

public:
    vector<ASFrame> frame;
    ASAnimation()
    {
        w = 0;
        h = 0;

        blitRect.x = 0;
        blitRect.y = 0;
        blitRect.w = 0;
        blitRect.h = 0;

        lastUpdate = 0;

        pause = false;
        currentFrame = 0;

        pauseTime = 0;
        speed = 1;
        
        numLoops = -1;
        randimate = false;
    }
    ASAnimation(char* infoFile, float Speed = 1);
    ASAnimation(const vector<ASFrame>& Frames, float Speed = 1);
    
    ~ASAnimation()
    {
        
    }
    
    void loadAnim(const vector<ASFrame>& Frames);
    void loadAnim(char* infoFile);
    
    int draw(SDL_Surface* dest, float X, float Y);
    int drawCenter(SDL_Surface* dest, float X, float Y);
    int drawRotated(SDL_Surface* dest, float X, float Y, float degrees);
    int drawRotatedCenter(SDL_Surface* dest, float X, float Y, float degrees);
    int drawScaled(SDL_Surface* dest, float X, float Y, float scale);
    int drawScaledCenter(SDL_Surface* dest, float X, float Y, float scale);

    void toggle()
    {
        if(pause)
            play();
        else
            stop();
    }

    void play(int numTimes = -1)
    {
        numLoops = numTimes;
        if(pause)
        {
            if(lastUpdate >= 0)
                lastUpdate = SDL_GetTicks() + pauseTime;  // does this work with speed?
            pause = 0;
        }
    }
    
    void stop()
    {
        if(!pause)
        {
            pauseTime = int((SDL_GetTicks() - lastUpdate) * speed) - frame[currentFrame].delay;
            pause = 1;
        }
    }
    
    void reset()
    {
        currentFrame = 0;
        lastUpdate = -1;
    }

    void setFrame(unsigned int index)
    {
        if (index >= 0 && index < frame.size())
            currentFrame = index;
        lastUpdate = -1;
    }

    int getFrame()
    {
        return currentFrame;
    }

    int getNumFrames()
    {
        return frame.size();
    }

    int getW()
    {
        return w;
    }

    int getH()
    {
        return h;
    }
    
    float getSpeed()
    {
        return speed;
    }
    
    float setSpeed(float Speed = 1)
    {
        speed = Speed;
        return speed;
    }
    
    bool randimate;  // random animation

};


#endif
